/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.slf4j;

import com.openhtmltopdf.util.Diagnostic;
import com.openhtmltopdf.util.XRLog;
import com.openhtmltopdf.util.XRLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
implements XRLogger {
    private static final String DEFAULT_LOGGER_NAME = "com.openhtmltopdf.other";
    private static final Map<String, String> LOGGER_NAME_MAP = new HashMap<String, String>();
    private String _defaultLoggerName = "com.openhtmltopdf.other";
    private Map<String, String> _loggerNameMap = LOGGER_NAME_MAP;

    @Override
    public boolean isLogLevelEnabled(Diagnostic diagnostic) {
        Level level = diagnostic.getLevel();
        Logger logger = LoggerFactory.getLogger(this.getLoggerName(diagnostic.getLogMessageId().getWhere()));
        if (level == Level.SEVERE) {
            return logger.isErrorEnabled();
        }
        if (level == Level.WARNING) {
            return logger.isWarnEnabled();
        }
        if (level == Level.INFO || level == Level.CONFIG) {
            return logger.isInfoEnabled();
        }
        if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
            return logger.isDebugEnabled();
        }
        return true;
    }

    @Override
    public void log(Diagnostic diagnostic) {
        Logger logger = LoggerFactory.getLogger(this.getLoggerName(diagnostic.getLogMessageId().getWhere()));
        Level level = diagnostic.getLevel();
        String msg = diagnostic.getLogMessageId().getMessageFormat();
        Object[] args = diagnostic.getArgs();
        if (level == Level.SEVERE) {
            logger.error(msg, args);
        } else if (level == Level.WARNING) {
            logger.warn(msg, args);
        } else if (level == Level.INFO || level == Level.CONFIG) {
            logger.info(msg, args);
        } else if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
            logger.debug(msg, args);
        } else {
            logger.info(msg, args);
        }
    }

    @Override
    public void log(String where, Level level, String msg) {
        Logger logger = LoggerFactory.getLogger(this.getLoggerName(where));
        if (level == Level.SEVERE) {
            logger.error(msg);
        } else if (level == Level.WARNING) {
            logger.warn(msg);
        } else if (level == Level.INFO || level == Level.CONFIG) {
            logger.info(msg);
        } else if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
            logger.debug(msg);
        } else {
            logger.info(msg);
        }
    }

    @Override
    public void log(String where, Level level, String msg, Throwable th) {
        Logger logger = LoggerFactory.getLogger(this.getLoggerName(where));
        if (level == Level.SEVERE) {
            logger.error(msg, th);
        } else if (level == Level.WARNING) {
            logger.warn(msg, th);
        } else if (level == Level.INFO || level == Level.CONFIG) {
            logger.info(msg, th);
        } else if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
            logger.debug(msg, th);
        } else {
            logger.info(msg, th);
        }
    }

    private String getLoggerName(String xrLoggerName) {
        String result = this._loggerNameMap.get(xrLoggerName);
        if (result != null) {
            return result;
        }
        return this._defaultLoggerName;
    }

    @Override
    public void setLevel(String logger, Level level) {
        throw new UnsupportedOperationException("log4j should be not be configured here");
    }

    public Map<String, String> getLoggerNameMap() {
        return this._loggerNameMap;
    }

    public void setLoggerNameMap(Map<String, String> loggerNameMap) {
        this._loggerNameMap = loggerNameMap;
    }

    public String getDefaultLoggerName() {
        return this._defaultLoggerName;
    }

    public void setDefaultLoggerName(String defaultLoggerName) {
        this._defaultLoggerName = defaultLoggerName;
    }

    static {
        LOGGER_NAME_MAP.put(XRLog.CONFIG, "com.openhtmltopdf.config");
        LOGGER_NAME_MAP.put(XRLog.EXCEPTION, "com.openhtmltopdf.exception");
        LOGGER_NAME_MAP.put(XRLog.GENERAL, "com.openhtmltopdf.general");
        LOGGER_NAME_MAP.put(XRLog.INIT, "com.openhtmltopdf.init");
        LOGGER_NAME_MAP.put(XRLog.JUNIT, "com.openhtmltopdf.junit");
        LOGGER_NAME_MAP.put(XRLog.LOAD, "com.openhtmltopdf.load");
        LOGGER_NAME_MAP.put(XRLog.MATCH, "com.openhtmltopdf.match");
        LOGGER_NAME_MAP.put(XRLog.CASCADE, "com.openhtmltopdf.cascade");
        LOGGER_NAME_MAP.put(XRLog.XML_ENTITIES, "com.openhtmltopdf.load.xmlentities");
        LOGGER_NAME_MAP.put(XRLog.CSS_PARSE, "com.openhtmltopdf.cssparse");
        LOGGER_NAME_MAP.put(XRLog.LAYOUT, "com.openhtmltopdf.layout");
        LOGGER_NAME_MAP.put(XRLog.RENDER, "com.openhtmltopdf.render");
    }
}

