/*
 * Decompiled with CFR 0.152.
 */
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

public class Main {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Uso: java -jar html2pdf.jar <inputHtml|ruta_html> <outputPdf>");
            System.err.println("Ejemplo: java -jar html2pdf.jar sample/index.html out.pdf");
            System.exit(1);
        }
        String input = args[0];
        String outputPdf = args[1];
        String baseUri = null;
        try {
            String html;
            Path possibleFile = Paths.get(input, new String[0]);
            if (Files.exists(possibleFile, new LinkOption[0]) && Files.isRegularFile(possibleFile, new LinkOption[0])) {
                html = Main.readFileSmart(possibleFile);
                baseUri = possibleFile.toAbsolutePath().getParent().toUri().toString();
            } else {
                html = input;
                baseUri = new File(".").toURI().toString();
            }
            File outFile = new File(outputPdf);
            if (outFile.getParentFile() != null) {
                outFile.getParentFile().mkdirs();
            }
            try (FileOutputStream os = new FileOutputStream(outFile);){
                html = Main.toXhtml(html);
                PdfRendererBuilder builder = new PdfRendererBuilder();
                builder.withHtmlContent(html, baseUri);
                builder.useFastMode();
                Main.registerBundledFonts(builder);
                builder.toStream(os);
                builder.run();
            }
            System.out.println("PDF generado en: " + outFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void registerBundledFonts(PdfRendererBuilder builder) {
        String[] fonts = new String[]{"/fonts/NotoSans-Regular.ttf", "/fonts/NotoSans-Bold.ttf", "/fonts/NotoSans-Italic.ttf", "/fonts/NotoSans-BoldItalic.ttf"};
        int count = 0;
        for (String res : fonts) {
            final byte[] data = Main.readResourceBytes(res);
            if (data != null && data.length > 0) {
                FSSupplier<InputStream> supplier = new FSSupplier<InputStream>(){

                    @Override
                    public InputStream supply() {
                        return new ByteArrayInputStream(data);
                    }
                };
                builder.useFont(supplier, "Noto Sans");
                System.out.println("Fuente incrustada desde JAR: " + res + " (" + data.length + " bytes)");
                ++count;
                continue;
            }
            if (data != null) {
                System.err.println("Aviso: " + res + " existe pero est\u00e1 vac\u00eda; se omite.");
                continue;
            }
            System.err.println("No encontrada en classpath: " + res);
        }
        if (count == 0) {
            System.err.println("No se incrust\u00f3 ninguna fuente desde el JAR. Se usar\u00e1n fuentes del sistema.");
        } else {
            System.out.println("Usa en tu CSS: body { font-family: 'Noto Sans', sans-serif; }");
        }
    }

    private static byte[] readResourceBytes(String path) {
        InputStream is = Main.class.getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        try {
            int n;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((n = is.read(buf)) != -1) {
                baos.write(buf, 0, n);
            }
            is.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            System.err.println("Error leyendo recurso " + path + ": " + e.getMessage());
            return null;
        }
    }

    private static String readFileSmart(Path path) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        if (bytes.length >= 3 && (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191) {
            return new String(bytes, 3, bytes.length - 3, StandardCharsets.UTF_8);
        }
        if (bytes.length >= 2) {
            int b0 = bytes[0] & 0xFF;
            int b1 = bytes[1] & 0xFF;
            if (b0 == 254 && b1 == 255) {
                return new String(bytes, "UTF-16BE");
            }
            if (b0 == 255 && b1 == 254) {
                return new String(bytes, "UTF-16LE");
            }
        }
        try {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            return new String(bytes, "ISO-8859-1");
        }
    }

    private static String toXhtml(String html) {
        Document doc = Jsoup.parse(html);
        doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml).escapeMode(Entities.EscapeMode.xhtml).charset("UTF-8").prettyPrint(false);
        return doc.outerHtml();
    }
}

